/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh tree; // tree mesh
/******************************************************************************/
void InitPre()
{
   App.name="Tree";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.3);
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=14;
   Cam.at.set(0,8,0);

   Sun.set(*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower(); // sun
   Sky.set();                                              // sky
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button
   if(Kb.bp(KB_TAB))D.ambMode(!D.ambMode());                  // toggle ambient occlusion on tab pressed
   
   if(Kb.bp(KB_SPACE))
   {
      // create the tree
      Memb<Material*> leaf_materials; // container of leaf materials
      leaf_materials.New()=Materials("mtrl/leaf/0/0.mtrl");
      leaf_materials.New()=Materials("mtrl/leaf/0/1.mtrl");

      tree.createTree(Materials("mtrl/bark/0.mtrl"),leaf_materials)
          .setRender ();
   }
   UpdateGrassAndLeafs(); // call this to update wind bending
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         tree.draw(MatrixIdentity);
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press Space to create a tree");
}
/******************************************************************************/
